/*
 * Decompiled with CFR 0.152.
 */
package com.fizzware.dramaticdoors.forge.forge;

import com.fizzware.dramaticdoors.forge.compat.CompatChecker;
import com.fizzware.dramaticdoors.forge.compat.Compats;
import com.fizzware.dramaticdoors.forge.forge.config.DDConfigForge;
import com.fizzware.dramaticdoors.forge.items.ModdedTab;
import java.util.function.Supplier;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.fml.loading.LoadingModList;
import org.jetbrains.annotations.Nullable;

public class ForgeUtils
implements CompatChecker,
ModdedTab {
    public static final ForgeUtils INSTANCE = new ForgeUtils();
    protected static boolean hasQuarkDoubleDoor = DDConfigForge.getConfigBooleanValue(DDConfigForge.CONFIG, FMLPaths.CONFIGDIR.get().resolve("quark-common.toml"), "tweaks.Double Door Opening");

    @Override
    public boolean isModLoaded(String modid) {
        if (LoadingModList.get().getModFileById(modid) != null) {
            return true;
        }
        return ModList.get().isLoaded(modid);
    }

    @Override
    public boolean isDev() {
        if (!FMLEnvironment.production) {
            return true;
        }
        return (Boolean)DDConfigForge.devMode.get();
    }

    @Override
    public boolean isQuarkModuleEnabled() {
        return Compats.QUARK_INSTALLED && hasQuarkDoubleDoor;
    }

    public boolean isDevEnvOnForge() {
        return !FMLEnvironment.production || (Boolean)DDConfigForge.devMode.get() != false;
    }

    @Override
    public CreativeModeTab createTab(String tabname, final Supplier<ItemStack> supplier, @Nullable String modid) {
        if (modid != null) {
            return this.isModLoaded(modid) ? new CreativeModeTab(tabname){

                public ItemStack m_6976_() {
                    return (ItemStack)supplier.get();
                }
            } : null;
        }
        return new CreativeModeTab(tabname){

            public ItemStack m_6976_() {
                return (ItemStack)supplier.get();
            }
        };
    }

    @SubscribeEvent
    public void onWorldLoad(LevelEvent.Load e) {
        hasQuarkDoubleDoor = DDConfigForge.getConfigBooleanValue(DDConfigForge.CONFIG, FMLPaths.CONFIGDIR.get().resolve("quark-common.toml"), "tweaks.Double Door Opening");
    }
}

